﻿/*
	VERSION: 		1.2
	1.2		Fix: 		sendEvent() was not targeting _this
				Change:	Component compatibillity.
								Added a redundant "reveal" event.
								set_visible() accepts an optional "noEvent" flag and respects it,  because components sometimes use it.
	1.1		Add: 		changing visibility also changes visibility of all immediate children  (they're restored to their previous state upon "show")
	
	USAGE:
		#include "functions/visibility_events.as"
		
		react.to("hide").then = ...
		_this.visible = false;
		
		
	BUG: 
		setTimeout()  cannot trigger the "visible" property.  So this will fail for some reason: 
			#include "functions/visibility_events.as"
			visible = false;
			setTimeout( function(){
				visible = true;				// set_visible() does not get called.
			}, 1000 );
			
		Properties with any other name are not affected by this glitch.
		To get around this,  _this.set_visible() is accessible to be used directly.
			#include "functions/visibility_events.as"
			visible = false;
			setTimeout( function(){
				visible = true;				// default technique
				set_visible( true );	// this will always work
			}, 1000 );

		
		
	WHAT IT'S FOR: 
		This adds a "visible" property and fires "show" and "hide" events when it changes.  (Exactly like a component does)
	
	
	NOTE: 
		Movieclips with visibility_events can be stacked within each other.
		When a change occurs,  the chidren will recursively deactivate/re-activate each other.  (each child is only responsible for its immediate children)  (cascading results in top-down recursion)
		
		This uses recurseClips.as instead of a simple for...in loop to avoid accidentally affecting any movieClip references.
		
		Components already have the "visible" property,  and already fire "reveal" and "hide" events...
		... but they do NOT tell their children.  You can safely use this to over-write their property.  I have already checked how UIObject impliments its "visible" property to avoid problems.
	
	
	LEAKS: 
		_this
		runFunc()
		hasProperty_visible
		set_visible
*/
if(!_this)		_this = this;
function runFunc( func ){
	return func.apply( _this, arguments.slice() );
}// runFunc()


runFunc(function(){
	#include "functions/sendEvent.as"
	#include "functions/recurseClips.as"
	
	// if:  "visible" property does not exist		(hasOwnProperty() will mistakenly return true if "visible" is set as a raw variable ahread of time)
	if( _this.hasProperty_visible !== true ){
		_this.hasProperty_visible = true;
		// visible
		var init_visible;
		if( _this.visible !== undefined )		init_visible = _this.visible;
		else																init_visible = _this._visible;
		var get_visible = function(){
			return _this._visible;
		}
		var set_visible = function( newValue, noEvent ){
			newValue = Boolean(newValue);
			// mdm.Exception.DebugWindow.trace("set_visible()  from: " + _this._visible + "  to: " + newValue);
			if( newValue === _this._visible)		return;
			_this._visible = newValue;
			if( noEvent === true )		return;		// Components use this flag.  My stuff doesn't have it.
			if(newValue === true){
				sendEvent("show", null, _this);
				sendEvent("reveal", null, _this);		// components use this instead of "show"
				showChildren();
			}
			if(newValue === false){
				sendEvent("hide", null, _this);
				hideChildren();
			}
		}// set()
		_this.set_visible = set_visible;		// fallback method to get around the setTimeout glitch.
		_this.addProperty("visible", get_visible, set_visible);
		// _this.addProperty("merf", get_visible, set_visible);
		if( init_visible !== undefined )		_this.visible = init_visible;
	}// if:  "visible" property does not exist
	
	
	// hide immediate children  (indirectly trigger "hide" events within them, so they can choose not to run while hidden)
	var childVisList = [];
	function hideChildren(){
		if( childVisList.length > 0 )		return;		// already hidden and recorded
		// else...
		// only affect immediate children
		recurseClips( _this, function( thisItem ){
			var visState = thisItem.visible;
			if( visState === undefined )		return;
			// else...
			// remember visibility state
			var newEntry = {
				ref: thisItem, 
				visState: visState
			}
			childVisList.push( newEntry );
			// make hidden  +  fire "hide" event
			thisItem.visible = false;
		}, false, true );
	}// hideChildren()
	
	function showChildren(){
		if( childVisList.length === 0 )		return;		// nothing to restore
		// else...
		// for:  each item that was hidden
		for(var i=childVisList.length-1; i>=0; i--){
			var thisEntry = childVisList[ i ];
			// restore previous visibility  +  fire "show" event if true
			thisEntry.ref.visible = thisEntry.visState;
		}// for:  each item that was hidden
		// forget all visibility states
		childVisList = [];
	}// showChildren()
	
});// runFunc()